unit utils;

#include consts, wcp, pilots;

var
  m_AliveEnemies, // this will hold the number of spawned ships
  m_DeadEnemies;  // and this the number of ships that have been killed
                  // we can easily check if all spawned ships have been
                  // killed by testing (m_AliveEnemies = m_DeadEnemies)

function S_EnemyFighter; forward;
function S_EnemyFighterDeath; forward;

function M_Spawn(shipId, count, x, y, z);
//
// this function spawns "count" ships of type "shipID"
// at coordinates around x, y, z
//
var
  ox, oy, oz;
begin
  while(count > 0) do begin
    ox := x + SYS_Random(600) - 300;
    oy := y + SYS_Random(600) - 300;
    oz := z + SYS_Random(600) - 300;

    NAV_CreateShip(shipId, PILOT_Alien1, 0, @S_EnemyFighter, @S_EnemyFighterDeath, ox, oy, oz);
    AI_WaitMilliseconds(275);
    count := count - 1;
  end;
end;

function M_SpawnNearObject(shipId, count, obj);
//
// this function spawns "count" ships of type "shipID"
// at coordinates near the object given in "obj"
//
var
  x, y, z,
  ox, oy, oz;
begin
  x := SF_GetXObj(obj);
  y := SF_GetYObj(obj);
  z := SF_GetZObj(obj);

  while(count > 0) do begin
    ox := x + SYS_Random(600) + 500;
    oy := y + SYS_Random(600) + 500;
    oz := z + SYS_Random(600) + 500;

    NAV_CreateShip(shipId, PILOT_Alien1, 0, @S_EnemyFighter, @S_EnemyFighterDeath, ox, oy, oz);
    AI_WaitMilliseconds(275);
    count := count - 1;
  end;
end;

function M_SpawnLaunchFrom(shipId, count, obj);
//
// this function lanuches "count" ships of type "shipID"
// from the capship given in "obj"
//
var
  i;
begin
  for i := 0 to (count - 1) do begin
    NAV_CreateShipLaunch(shipId, PILOT_Alien1, 0, @S_EnemyFighter, @S_EnemyFighterDeath, obj);
    AI_WaitSeconds(2);
  end;
end;

function S_EnemyFighter;
begin
  SF_SetObjectFlag(OF_vulnerable, 1);
  SF_SetObjectFlag(OF_alignment, ALIGN_ALIEN);
  SF_BindToActionSphere(0);
  m_AliveEnemies := m_AliveEnemies + 1;

  SF_SetObjectFlag(OF_collidable, 0);
  SF_ActivateSelf(0);
  AI_AttackNothing(1);
  AI_SetThrottle(100);
  AI_WaitSeconds(6);
  SF_SetObjectFlag(OF_collidable, 1);
  AI_AttackNothing(0);

  AI_AttackEnemies;

  while (1) do
    AI_WaitSeconds(1);
end;

function S_EnemyFighterDeath;
begin
  m_DeadEnemies := m_DeadEnemies + 1;
end;

function M_WaitUntilDead;
//
// this function waits until all enemies spawned by M_Spawn*
// have been killed.
//
begin
  until(m_DeadEnemies = m_AliveEnemies) do
    AI_WaitSeconds(1);
end;

function M_EnemiesDead;
//
// this functions returns true if all enemies spawned by M_Spawn*
// have been killed.
//
begin
  Result := (m_DeadEnemies = m_AliveEnemies);
end;

function M_CountEnemies;
//
// this function returns the number of alive enemies spawned by M_Spawn*
//
begin
  Result := m_AliveEnemies - m_DeadEnemies;
end;
