library misb5;

uses
  SysUtils,
  Classes,
  Windows,
  Forms,
  Dialogs,
  SyntaxEditor, // http://www.lischke-online.de/Unicode.html
  menus,
  builder5 in 'builder5.pas',
  tools in 'Tools.pas';

var
  HostHandle: longint;
  MainForm: TForm;

{$R *.RES}

type
  TextGetMainForm = function: TForm;
  TextGetApplication = function: TApplication;
  TextGetActiveEdit = function: TSyntaxEdit;

var
  extGetActiveEdit: TextGetActiveEdit;
  builder: TMISB5;

procedure init_ext(handle: longint);
var
  GetMainForm: TextGetMainForm;
  GetHostApplication: TextGetApplication;
begin
  HostHandle := handle;

  GetMainForm := GetProcAddress(HostHandle, 'extGetMainForm');
  MainForm := GetMainForm;
  tools.MainForm := MainForm;
  GetHostApplication := GetProcAddress(HostHandle, 'extGetApplication');
  Application.Handle := GetHostApplication.Handle;
  extGetActiveEdit := GetProcAddress(HostHandle, 'extGetActiveEdit');

  builder := TMISB5.Create;
  builder.ActiveEdit := extGetActiveEdit;
  builder.MainForm := MainForm;
  builder.RegisterMenus;
end;

procedure unload_ext;
begin
  if (Assigned(builder)) then begin
    builder.UnRegisterMenus;
    builder.free;
    builder := nil;
  end;
end;

// the plug-in only exports two functions. When it is loaded wcppas calls
// init_ext and passes it's handle. The plugin can then use this handle to
// GetProcAddress the functions from wcppas.exe

// wcppas calls unload_ext when before the plug-in is unloaded. 

// functions exported from wcppas.exe:
//
// function extGetMainForm: TForm;
// function extGetApplication: TApplication;
// function extGetActiveEdit: TSyntaxEdit;

exports
  init_ext index 0,
  unload_ext index 1;

begin
end.
