unit builder5;

interface uses SyntaxEditor, Classes, Forms, Menus;

type
  TextGetActiveEdit = function: TSyntaxEdit;

  TMISB5 = class
  private
    FGetActiveEdit: TextGetActiveEdit;
    FMainForm: TForm;

    function AddMenu(const Parent, Caption, Name: string; action: TNotifyEvent): TMenuItem;
  public
    procedure RegisterMenus;
    procedure UnRegisterMenus;

    procedure CreateNav(Sender: TObject);

    property ActiveEdit: TextGetActiveEdit read FGetActiveEdit write FGetActiveEdit;
    property MainForm: TForm read FMainForm write FMainForm;
  end;

implementation uses Dialogs;

function TMISB5.AddMenu(const Parent, Caption, Name: string; action: TNotifyEvent): TMenuItem;
var
  m: TMenuItem;
  parent_menu: TMenuItem;
begin
  parent_menu := TMenuItem(MainForm.FindComponent(Parent));
  showmessage(parent_menu.caption);

  m := TMenuItem.Create(MainForm);
  m.Caption := Caption;
  m.OnClick := Action;
  m.Name := name;

  parent_menu.Add(m);

  Result := m;
end;

procedure TMISB5.UnRegisterMenus;
begin
  // a clean plug-in should remove it's menu items at the end of its
  // life span. But since Windows will take care of it anyway ... :)
end;

procedure TMISB5.RegisterMenus;
begin
  AddMenu('MenuEdit', 'MISB5', 'MenuEditBuilder', nil);
  AddMenu('MenuEditBuilder', 'Add Navpoint', 'MenuEditBuilderCreateNav', CreateNav);
end;

procedure TMISB5.CreateNav(Sender: TObject);
var
  name: string;
begin
  name := InputBox('New Nav', 'Input the name of the new navpoint' , 'Nav1');

  ActiveEdit.SelText := 'object ' + name + '(Navpoint)'#13+
                        '  x: 0;'#13+
                        '  y: 0;'#13+
                        '  z: 2000;'#13+
                        '  main: M_' + name + ';'#13+
                        '  name: spacefli["' + name + '"];'#13+
                        '  navdata: 1, 25000;'#13+
                        'end;'#10#13
end;


end.
