unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, SyntaxEditor;

type
  TextGetActiveEdit = function: TSyntaxEdit;

  TfrmPlug = class(TForm)
    Button1: TButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    FGetActiveEdit: TextGetActiveEdit;
  public
    procedure SelectSelf;
    property ActiveEdit: TextGetActiveEdit read FGetActiveEdit write FGetActiveEdit;
  end;

var
  frmPlug: TfrmPlug;

implementation uses IniFiles, Tools, comctrls;

{$R *.DFM}

procedure TfrmPlug.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caHide;
end;

procedure TfrmPlug.FormCreate(Sender: TObject);
var
  ini: TIniFile;
begin
  DecimalSeparator := '.';
  ThousandSeparator := ',';
  DateSeparator := '/';

  ReadPanelSettings(self, Caption);

  ini := TIniFile.Create(ExtractFilePath(Application.ExeName) + 'wcppas.ini');
  ini.free;
end;

procedure TfrmPlug.FormDestroy(Sender: TObject);
begin
  SavePanelSettings(self, Caption);
end;

procedure TfrmPlug.SelectSelf;
var
  pc: TPageControl;
  i: longint;
begin
  if (not Visible) then Show;
  if (Assigned(HostDockSite)) then begin
    pc := (HostDockSite as TPageControl);

    for i := 0 to (pc.PageCount - 1) do
      if (pc.pages[i].Caption = Caption) then begin
        pc.ActivePageIndex := i;
        break;
      end;
  end;
end;

procedure TfrmPlug.Button1Click(Sender: TObject);
begin
  ActiveEdit.SelText := 'object ' + InputBox('New Nav', 'Input the name of the new navpoint' , 'Nav1') + '(Navpoint)'#13+
                        '  x: 0;'#13+
                        '  y: 0;'#13+
                        '  z: 2000;'#13+
                        '  main: M_NavD;'#13+
                        '  name: spacefli["Dauntless Nav"];'#13+
                        '  navdata: 1, 25000;'#13+
                        'end;'#10#13
end;

end.
