unit tools;

interface uses Forms;

procedure ReadPanelSettings(Sender: TForm; const name: string);
procedure SavePanelSettings(Sender: TForm; const name: string);

var
  MainForm: TForm;

implementation uses IniFiles, SysUtils, Controls;

procedure ReadPanelSettings(Sender: TForm; const name: string);
var
  ini: TIniFile;
  site: string;
begin
  ini := TIniFile.Create(ExtractFilePath(Application.ExeName) + 'wcppas.ini');

  with Sender do begin
    site := ini.ReadString(name, 'site', '');
    if (site <> '') then
      ManualDock(TWinControl(MainForm.FindComponent(site)), nil, alCLient)
    else begin
      WindowState := TWindowState(ini.ReadInteger(name, 'windowstate', Integer(wsNormal)));
      if (WindowState = wsNormal) then begin
        Top := ini.ReadInteger(name, 'top', Top);
        Left := ini.ReadInteger(name, 'left', Left);
        Height := ini.ReadInteger(name, 'height', Height);
        Width := ini.ReadInteger(name, 'width', Width);
      end;
    end;
    Visible := ini.ReadBool(name, 'visible', true);
  end;

  ini.free;
end;

procedure SavePanelSettings(Sender: TForm; const name: string);
var
  ini: TIniFile;
begin
  ini := TIniFile.Create(ExtractFilePath(Application.ExeName) + 'wcppas.ini');

  with Sender do begin
    if (Assigned(HostDockSite)) then
      ini.WriteString(name, 'site', HostDockSite.Name)
    else begin
      ini.WriteString(name, 'site', '');
      WindowState := TWindowState(ini.ReadInteger(name, 'windowstate', Integer(wsNormal)));
      if (WindowState = wsNormal) then begin
        ini.WriteInteger(name, 'top', Top);
        ini.WriteInteger(name, 'left', Left);
        ini.WriteInteger(name, 'height', Height);
        ini.WriteInteger(name, 'width', Width);
      end;
    end;
    ini.WriteBool(name, 'visible', true);
  end;

  ini.free;
end;


end.
